/*==============================================================================
 PART 1B: Final Panel Data Cleaning
==============================================================================
Purpose:
Performs final panel data cleaning and variable adjustments:
- Panel data structure validation and duplicate removal
- Creation of ratio variables for analysis (e.g., assets ratios)

Input:  Call Report data with variables from Part 1A
Output: Dataset ready for sample restrictions in Part 1C

Last updated: Aug 9, 2025
==============================================================================*/

display "--- Starting Part 1B: Final Panel Data Cleaning ---" // Indicate the start of the script

//==============================================================================
// Section 1: Panel Data Cleaning and Final Variable Adjustments
//==============================================================================

// Drop observations with missing bank or time identifiers (cert or yq)
drop if cert == 0 | missing(cert) | missing(yq)

// Check for and drop duplicate bank-quarter observations
duplicates tag cert yq, gen(dup)
drop if dup > 0
drop dup

// Declare the data as a panel dataset using cert (bank) and yq (quarter)
sort cert yq
tsset cert yq

// Final sort and variable ordering for consistency
sort rssdid yq
order rssdid yq
cap drop date // Drop redundant date variable if exists

//------------------------------------------------------------------------------
// Section 2: Ratio variables: divide most vars by assets
//------------------------------------------------------------------------------
// Deposit Ratios (relative to total assets)
gen ltdep_assets = timedepge250k / assets
gen stdep_assets = timedeple250k / assets
gen uninsuredsh_assets = uninsureddep / assets
replace uninsuredsh_assets = 0 if uninsuredsh_assets <= 0 
gen nondep_assets = (assets - domdep - foreigndep) / assets

gen zmdep_assets = zmdep / assets

gen domdep_assets = domdep / assets

gen foreigndep_assets = foreigndep / assets

//Asset Ratios (relative to total assets)
gen tradingassets_assets = tradingassets / assets

gen ciloans_assets = ciloans / assets

gen reloans_assets = reloans / assets

gen persloans_assets = persloans / assets

gen loans_assets = loans / assets

gen otherloans_assets = loans_assets - (reloans_assets + ciloans_assets + persloans_assets)

gen securities_assets = securities / assets

gen cash_assets = cash / assets

//Liability Ratios (relative to total assets)
gen tradingliabilities_assets = tradingliabilities / assets

gen obm_assets = otherborrowedmoney / assets

//Capital and Other Ratios
gen equity_assets = equity / assets

gen ln_assets = log(assets)

gen uninsuredsh_domdep = uninsureddep / domdep
replace uninsuredsh_domdep = 0 if uninsuredsh_domdep <= 0

gen cls_assets = (cash + securities + loans) / assets

gen cls_nontradeassets = (cash + securities + loans) / (assets - tradingassets)

//Ratios for Cost Regressions
gen coredep_assets = (transdep + savdep + stdep) / assets

gen trading_net_assets = (tradingassets - tradingliabilities) / assets

gen otherassets_assets = (assets - cash - fedfundsrepoasset - securities - loans - tradingassets) / assets

gen otherliabilities_assets = (assets - domdep - foreigndep - fedfundsrepoliab - tradingliabilities - otherborrowedmoney - equity) / assets

gen otherassets_net_assets = otherassets_assets - otherliabilities_assets

//Uninsured/Insured Deposit Ratios
gen uninszm_assets = (uninsureddep - ltdep) / assets
replace uninszm_assets = max(0, uninszm_assets)

gen inszm_assets = zmdep / assets - uninszm_assets

//Assets in Billions -- useful in tables.
gen assets_bill = assets / 1000000 // Call Reports are in thousands, 1e9/1e3 = 1000000


display "--- Part 1B completed ---" // Indicate the completion of the script
